/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.network;

import dev.architectury.networking.NetworkManager;
import io.github.thecsdev.tcdcommons.api.network.CustomPayloadNetworkReceiver;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2547;
import net.minecraft.class_2598;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_5455;
import net.minecraft.class_634;
import net.minecraft.class_746;
import net.minecraft.class_9129;
import org.jetbrains.annotations.ApiStatus;

public final class CustomPayloadNetwork {
    private CustomPayloadNetwork() {
    }

    @ApiStatus.Internal
    private static final NetworkManager.Side flow2side(class_2598 packetFlow) {
        return switch (packetFlow) {
            case class_2598.field_11941 -> NetworkManager.Side.C2S;
            case class_2598.field_11942 -> NetworkManager.Side.S2C;
            default -> throw new IllegalArgumentException("Invalid packet flow - " + String.valueOf(packetFlow));
        };
    }

    public static final CustomPayloadNetworkReceiver registerReciever(class_2598 side, class_2960 id, CustomPayloadNetworkReceiver receiver) {
        NetworkManager.Side archSide = CustomPayloadNetwork.flow2side(Objects.requireNonNull(side));
        Objects.requireNonNull(id);
        Objects.requireNonNull(receiver);
        NetworkManager.registerReceiver((NetworkManager.Side)archSide, (class_2960)id, (buffer, ctx) -> {
            class_634 connection = switch (archSide) {
                default -> throw new MatchException(null, null);
                case NetworkManager.Side.S2C -> ((class_746)ctx.getPlayer()).field_3944;
                case NetworkManager.Side.C2S -> ((class_3222)ctx.getPlayer()).field_13987;
            };
            receiver.receiveCustomPayload(new CustomPayloadNetworkReceiver.PacketContext(){
                final /* synthetic */ class_2547 val$connection;
                final /* synthetic */ class_2598 val$side;
                final /* synthetic */ class_2960 val$id;
                final /* synthetic */ class_9129 val$buffer;
                final /* synthetic */ NetworkManager.PacketContext val$ctx;
                {
                    this.val$connection = class_25472;
                    this.val$side = class_25982;
                    this.val$id = class_29602;
                    this.val$buffer = class_91292;
                    this.val$ctx = packetContext;
                }

                @Override
                public class_2547 getPacketListener() {
                    return this.val$connection;
                }

                @Override
                public class_2598 getNetworkSide() {
                    return this.val$side;
                }

                @Override
                public class_2960 getPacketId() {
                    return this.val$id;
                }

                @Override
                public class_2540 getPacketBuffer() {
                    return this.val$buffer;
                }

                @Override
                public class_1657 getPlayer() {
                    return this.val$ctx.getPlayer();
                }
            });
        });
        return receiver;
    }

    public static final void sendC2S(class_2960 id, ByteBuf buffer) {
        Objects.requireNonNull(id);
        Objects.requireNonNull(buffer);
        try {
            NetworkManager.sendToServer((class_2960)id, (class_9129)new class_9129(buffer, (class_5455)class_310.method_1551().method_1562().method_29091()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final void sendS2C(class_3222 player, class_2960 id, ByteBuf buffer) {
        Objects.requireNonNull(player);
        Objects.requireNonNull(id);
        Objects.requireNonNull(buffer);
        try {
            NetworkManager.sendToPlayer((class_3222)player, (class_2960)id, (class_9129)new class_9129(buffer, player.method_56673()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

