/*
 * Decompiled with CFR 0.152.
 */
package arm32x.minecraft.commandblockide.client.gui.editor;

import arm32x.minecraft.commandblockide.client.Dirtyable;
import arm32x.minecraft.commandblockide.client.gui.Container;
import arm32x.minecraft.commandblockide.client.gui.MultilineTextFieldWidget;
import arm32x.minecraft.commandblockide.client.processor.CommandProcessor;
import arm32x.minecraft.commandblockide.client.processor.MultilineCommandProcessor;
import arm32x.minecraft.commandblockide.client.processor.StringMapping;
import arm32x.minecraft.commandblockide.mixin.client.ChatInputSuggestorAccessor;
import arm32x.minecraft.commandblockide.mixinextensions.client.ChatInputSuggestorExtension;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.brigadier.context.StringRange;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.IntConsumer;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4717;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public abstract class CommandEditor
extends Container
implements Dirtyable {
    private final int x;
    private int y;
    private int width;
    private int height;
    private final int leftPadding;
    private final int rightPadding;
    public final int index;
    public boolean lineNumberHighlighted = false;
    protected final class_327 textRenderer;
    protected final MultilineTextFieldWidget commandField;
    protected final class_4717 suggestor;
    protected final CommandProcessor processor = MultilineCommandProcessor.getInstance();
    private boolean suggestorActive = false;
    private boolean loaded = false;
    @Nullable
    protected IntConsumer heightChangedListener = null;
    private static final List<class_2583> ARGUMENT_STYLES = Stream.of(class_124.field_1075, class_124.field_1054, class_124.field_1060, class_124.field_1076, class_124.field_1065).map(arg_0 -> ((class_2583)class_2583.field_24360).method_10977(arg_0)).toList();
    private static final class_2583 INFO_STYLE = class_2583.field_24360.method_10977(class_124.field_1080);
    private static final class_2583 ERROR_STYLE = class_2583.field_24360.method_10977(class_124.field_1061);
    private static final class_2583 COMMENT_STYLE = class_2583.field_24360.method_10977(class_124.field_1063);

    public CommandEditor(class_437 screen, class_327 textRenderer, int x, int y, int width, int height, int leftPadding, int rightPadding, int index) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.leftPadding = leftPadding;
        this.rightPadding = rightPadding;
        this.index = index;
        this.textRenderer = textRenderer;
        this.commandField = this.addSelectableChild(new MultilineTextFieldWidget(textRenderer, x + leftPadding + 20, y, width - leftPadding - rightPadding - 20, height, (class_2561)class_2561.method_43471((String)"advMode.command").method_10852((class_2561)class_2561.method_43469((String)"commandBlockIDE.narrator.editorIndex", (Object[])new Object[]{index + 1}))){

            protected class_5250 method_25360() {
                return super.method_25360().method_10852(CommandEditor.this.suggestor.method_23958());
            }
        });
        this.commandField.method_1888(false);
        this.commandField.method_1880(Integer.MAX_VALUE);
        this.suggestor = new class_4717(class_310.method_1551(), screen, (class_342)this.commandField, textRenderer, true, true, 0, 16, false, Integer.MIN_VALUE);
        ((ChatInputSuggestorExtension)this.suggestor).ide$setCommandProcessor(this.processor);
        this.suggestor.method_23934();
        this.commandField.method_1863(this::commandChanged);
        this.commandField.setCursorChangeListener(() -> ((class_4717)this.suggestor).method_23934());
        this.commandField.setSyntaxHighlighter(text -> {
            ParseResults<class_2172> parse = ((ChatInputSuggestorAccessor)this.suggestor).getParse();
            if (parse != null) {
                return CommandEditor.highlight(parse, text, (StringMapping)this.processor.processCommand(text).method_15441());
            }
            return MultilineTextFieldWidget.SyntaxHighlighter.NONE.highlight(text);
        });
    }

    public void commandChanged(String newCommand) {
        this.suggestor.method_23934();
        this.setHeight(this.commandField.getLineCount() * this.commandField.getLineHeight() + 4);
    }

    public boolean method_25404(class_11908 input) {
        if (this.handleSpecialKey(input)) {
            return true;
        }
        if (this.isSuggestorActive() && this.suggestor.method_23924(input)) {
            return true;
        }
        if (this.commandField.method_25404(input)) {
            this.setSuggestorActive(false);
            return true;
        }
        return false;
    }

    private boolean handleSpecialKey(class_11908 input) {
        if (input.comp_4795() == 258 && !this.isSuggestorActive() && !this.commandField.isBeforeFirstNonWhitespaceCharacterInLine(this.commandField.method_1881())) {
            this.setSuggestorActive(true);
            this.suggestor.method_23934();
            return this.suggestor.method_23924(new class_11908(258, -1, 0));
        }
        if (input.comp_4795() == 32 && input.method_74240()) {
            this.setSuggestorActive(true);
            this.suggestor.method_23920(true);
            return true;
        }
        return false;
    }

    public boolean method_25400(class_11905 input) {
        if (super.method_25400(input)) {
            this.setSuggestorActive(true);
            this.suggestor.method_23934();
            return true;
        }
        return false;
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        boolean result = this.suggestor.method_23922(click) || super.method_25402(click, doubled);
        this.suggestor.method_23933(false);
        return result;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        return this.suggestor.method_23921(verticalAmount) || super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public void method_25365(boolean focused) {
        this.method_25395((class_364)this.commandField);
        this.commandField.method_25365(focused);
        this.suggestor.method_23933(false);
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.renderLineNumber(context);
        if (this.isLoaded()) {
            this.renderCommandField(context, mouseX, mouseY, delta);
        } else {
            context.method_51439(this.textRenderer, (class_2561)class_2561.method_43471((String)"commandBlockIDE.unloaded"), this.commandField.method_46426(), this.y + 5, Integer.MAX_VALUE, false);
        }
        super.method_25394(context, mouseX, mouseY, delta);
    }

    protected void renderLineNumber(class_332 context) {
        String lineNumber = String.valueOf(this.index + 1);
        context.method_51433(this.textRenderer, lineNumber, this.x + 17 - this.textRenderer.method_1727(lineNumber), this.y + 5, 0x3F000000, false);
        context.method_51433(this.textRenderer, lineNumber, this.x + 16 - this.textRenderer.method_1727(lineNumber), this.y + 4, this.lineNumberHighlighted ? -1 : Integer.MAX_VALUE, false);
    }

    protected void renderCommandField(class_332 context, int mouseX, int mouseY, float delta) {
        this.commandField.field_22764 = true;
        this.commandField.method_25394(context, mouseX, mouseY, delta);
    }

    public void renderSuggestions(class_332 context, int mouseX, int mouseY) {
        if (this.commandField.method_20315()) {
            this.suggestor.method_23923(context, mouseX, mouseY);
        }
    }

    public String getSingleLineCommand() {
        return (String)this.processor.processCommand(this.commandField.method_1882()).method_15442();
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    protected void setLoaded(boolean loaded) {
        this.loaded = loaded;
        this.commandField.method_1888(loaded);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
        this.commandField.method_46419(y);
        this.suggestor.method_23934();
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
        this.commandField.method_25358(width - this.leftPadding - this.rightPadding - 20);
        this.suggestor.method_23934();
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        boolean changed = height != this.height;
        this.height = height;
        this.commandField.method_53533(height);
        this.suggestor.method_23934();
        if (changed) {
            this.onHeightChange(height);
        }
    }

    public boolean isSuggestorActive() {
        return this.suggestorActive;
    }

    public void setSuggestorActive(boolean suggestorActive) {
        this.suggestor.method_23933(suggestorActive);
        this.suggestorActive = suggestorActive;
    }

    protected void onHeightChange(int height) {
        if (this.heightChangedListener != null) {
            this.heightChangedListener.accept(height);
        }
    }

    public void setHeightChangedListener(@Nullable IntConsumer listener) {
        this.heightChangedListener = listener;
    }

    public void method_37020(class_6382 builder) {
        builder.method_37034(class_6381.field_33788, (class_2561)class_2561.method_43469((String)"narration.edit_box", (Object[])new Object[]{this.commandField.method_1882()}));
    }

    protected static List<class_5481> highlight(ParseResults<class_2172> parse, String text, StringMapping mapping) {
        List<StringRange> ranges = parse.getContext().getLastChild().getArguments().values().stream().map(ParsedArgument::getRange).toList();
        int mappedParseStopIndex = mapping.mapIndexOrAfter(parse.getReader().getCursor());
        ArrayList<class_5481> highlightedLines = new ArrayList<class_5481>();
        int startIndex = 0;
        while (startIndex <= text.length()) {
            int endIndex = text.indexOf(10, startIndex);
            if (endIndex == -1) {
                endIndex = text.length();
            }
            int start = startIndex;
            int end = endIndex;
            highlightedLines.add(visitor -> {
                block0: for (int index = start; index < end; ++index) {
                    class_2583 style;
                    int codePoint = text.codePointAt(index);
                    if (codePoint < 65535 && Character.isSurrogate((char)codePoint)) continue;
                    OptionalInt maybeMappedIndex = mapping.inverted().mapIndex(index);
                    if (maybeMappedIndex.isEmpty()) {
                        if (visitor.accept(index, COMMENT_STYLE, codePoint)) continue;
                        return false;
                    }
                    int mappedIndex = maybeMappedIndex.getAsInt();
                    for (int rangeIndex = 0; rangeIndex < ranges.size(); ++rangeIndex) {
                        StringRange range = (StringRange)ranges.get(rangeIndex);
                        if (range.getStart() > mappedIndex || mappedIndex >= range.getEnd()) continue;
                        class_2583 style2 = ARGUMENT_STYLES.get(rangeIndex % ARGUMENT_STYLES.size());
                        if (visitor.accept(index, style2, codePoint)) continue block0;
                        return false;
                    }
                    class_2583 class_25832 = style = index >= mappedParseStopIndex ? ERROR_STYLE : INFO_STYLE;
                    if (visitor.accept(index, style, codePoint)) continue;
                    return false;
                }
                return true;
            });
            startIndex = endIndex + 1;
        }
        return highlightedLines;
    }
}

