/*
 * Decompiled with CFR 0.152.
 */
package arm32x.minecraft.commandblockide.client.gui.screen;

import arm32x.minecraft.commandblockide.client.Dirtyable;
import arm32x.minecraft.commandblockide.client.gui.ToolbarSeparator;
import arm32x.minecraft.commandblockide.client.gui.button.SimpleIconButton;
import arm32x.minecraft.commandblockide.client.gui.editor.CommandEditor;
import arm32x.minecraft.commandblockide.client.storage.MultilineCommandStorage;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_7919;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public abstract class CommandIDEScreen<E extends CommandEditor>
extends class_437
implements Dirtyable {
    protected final List<E> editors = new ArrayList();
    protected int combinedEditorHeight = Integer.MAX_VALUE;
    private boolean initialized = false;
    private SimpleIconButton saveButton;
    private int scrollOffset = 0;
    private int maxScrollOffset = Integer.MAX_VALUE;
    public static final double SCROLL_SENSITIVITY = 50.0;
    private boolean draggingScrollbar = false;
    private double mouseYAtScrollbarDragStart = 0.0;
    private int scrollOffsetAtScrollbarDragStart = 0;
    @Nullable
    protected class_2561 statusText = null;
    private int statusTextX = 0;

    public CommandIDEScreen() {
        super((class_2561)class_2561.method_43473());
    }

    protected void method_25426() {
        this.saveButton = new SimpleIconButton(0, 0, "save", class_7919.method_47407((class_2561)class_2561.method_43471((String)"commandBlockIDE.save")), b -> this.save());
        this.statusTextX = this.addToolbarWidgets(List.of(this.saveButton, new ToolbarSeparator()));
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, b -> {
            this.save();
            this.method_25419();
        }).method_46433(this.field_22789 - 216, this.field_22790 - 28).method_46437(100, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24335, b -> this.method_25419()).method_46433(this.field_22789 - 108, this.field_22790 - 28).method_46437(100, 20).method_46431());
        if (!this.initialized) {
            this.firstInit();
            this.initialized = true;
        } else {
            this.initAfterFirst();
        }
    }

    protected void firstInit() {
        this.setLoaded(false);
        this.repositionEditors();
        this.maxScrollOffset = Math.max(this.combinedEditorHeight - (this.field_22790 - 50), 0);
        this.setScrollOffset(this.getScrollOffset());
        MultilineCommandStorage.load();
    }

    protected void initAfterFirst() {
        for (CommandEditor editor : this.editors) {
            this.method_25429((class_364)editor);
            editor.setWidth(this.field_22789 - 16);
        }
        this.maxScrollOffset = Math.max(this.combinedEditorHeight - (this.field_22790 - 50), 0);
        class_364 element = this.method_25399();
        if (element instanceof CommandEditor) {
            this.setFocusedEditor((CommandEditor)element);
        }
    }

    protected void addEditor(E editor) {
        ((CommandEditor)editor).setHeightChangedListener(height -> {
            this.repositionEditors();
            this.setScrollOffset(Math.min(this.scrollOffset, this.combinedEditorHeight - 20));
        });
        this.editors.add(editor);
        this.method_25429((class_364)editor);
    }

    public void save() {
        MultilineCommandStorage.save();
    }

    public boolean method_25422() {
        return false;
    }

    public void method_25419() {
        super.method_25419();
    }

    public boolean method_25404(class_11908 input) {
        if (this.handleSpecialKey(input)) {
            return true;
        }
        if (this.method_25399() != null) {
            return this.method_25399().method_25404(input);
        }
        return false;
    }

    private boolean handleSpecialKey(class_11908 input) {
        if (input.comp_4795() == 256) {
            class_364 focused = this.method_25399();
            if (focused == null) {
                this.method_25419();
                return true;
            }
            if (focused instanceof CommandEditor) {
                CommandEditor editor = (CommandEditor)focused;
                if (editor.isSuggestorActive()) {
                    editor.setSuggestorActive(false);
                    return true;
                }
                editor.method_25365(false);
            }
            this.method_25395(null);
            return true;
        }
        if (input.comp_4795() == 257 || input.comp_4795() == 335) {
            class_364 focused = this.method_25399();
            if (focused == null) {
                this.save();
                this.method_25419();
                return true;
            }
            if (input.method_74240() && focused instanceof CommandEditor) {
                CommandEditor editor = (CommandEditor)focused;
                if (editor.isSuggestorActive()) {
                    editor.setSuggestorActive(false);
                    return true;
                }
                editor.method_25365(false);
                this.method_25395(null);
                return true;
            }
            return false;
        }
        if (input.comp_4795() == 265 && input.method_74240() || input.comp_4795() == 258 && input.method_74240() && input.method_74239()) {
            this.changeFocus(false);
            return true;
        }
        if (input.comp_4795() == 264 && input.method_74240() || input.comp_4795() == 258 && input.method_74240() && !input.method_74239()) {
            this.changeFocus(true);
            return true;
        }
        if (input.comp_4795() == 83 && input.method_74240()) {
            this.saveButton.method_25354(class_310.method_1551().method_1483());
            this.save();
            return true;
        }
        return false;
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        if (click.comp_4798() > (double)(this.field_22789 - 4) && click.method_74245() == 0) {
            int virtualHeight = this.maxScrollOffset + this.field_22790;
            int scrollbarHeight = Math.round((float)this.field_22790 / (float)virtualHeight * (float)this.field_22790);
            int scrollbarPosition = Math.round((float)this.getScrollOffset() / (float)this.field_22790 * (float)scrollbarHeight);
            if (click.comp_4799() >= (double)scrollbarPosition && click.comp_4799() <= (double)(scrollbarPosition + scrollbarHeight)) {
                this.method_25398(true);
                this.draggingScrollbar = true;
                this.mouseYAtScrollbarDragStart = click.comp_4799();
                this.scrollOffsetAtScrollbarDragStart = this.getScrollOffset();
            } else if (click.comp_4799() < (double)scrollbarPosition) {
                this.setScrollOffset((int)Math.round((double)this.getScrollOffset() - 250.0));
            } else if (click.comp_4799() > (double)(scrollbarPosition + scrollbarHeight)) {
                this.setScrollOffset((int)Math.round((double)this.getScrollOffset() + 250.0));
            }
            return true;
        }
        class_364 focusedChild = null;
        for (class_364 child : this.method_25396()) {
            if (!child.method_25402(click, doubled) || focusedChild != null) continue;
            focusedChild = child;
        }
        this.method_25395(focusedChild);
        if (click.method_74245() == 0) {
            this.method_25398(true);
        }
        return true;
    }

    public boolean method_25406(class_11909 click) {
        if (click.method_74245() == 0 && this.draggingScrollbar) {
            this.draggingScrollbar = false;
            return true;
        }
        return super.method_25406(click);
    }

    public boolean method_25403(class_11909 click, double offsetX, double offsetY) {
        if (click.method_74245() == 0 && this.draggingScrollbar) {
            int virtualHeight = this.maxScrollOffset + this.field_22790;
            int scrollbarHeight = Math.round((float)this.field_22790 / (float)virtualHeight * (float)this.field_22790);
            int scrollOffsetDelta = (int)Math.round((click.comp_4799() - this.mouseYAtScrollbarDragStart) / (double)scrollbarHeight * (double)this.field_22790);
            this.setScrollOffset(this.scrollOffsetAtScrollbarDragStart + scrollOffsetDelta);
            return true;
        }
        return super.method_25403(click, offsetX, offsetY);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        for (CommandEditor editor : this.editors) {
            if (!editor.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount)) continue;
            return true;
        }
        if (verticalAmount != 0.0 && mouseY < (double)(this.field_22790 - 36)) {
            this.setScrollOffset(this.getScrollOffset() - (int)Math.round(verticalAmount * 50.0));
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public int getScrollOffset() {
        return this.scrollOffset;
    }

    public void setScrollOffset(int offset) {
        int effectiveMaxScrollOffset = Math.max(this.scrollOffset, this.maxScrollOffset);
        this.scrollOffset = class_3532.method_15340((int)offset, (int)0, (int)effectiveMaxScrollOffset);
        this.repositionEditors();
    }

    protected void repositionEditors() {
        int heightAccumulator = 8;
        for (CommandEditor editor : this.editors) {
            editor.setY(heightAccumulator - this.scrollOffset);
            heightAccumulator += editor.getHeight() + 4;
        }
        this.combinedEditorHeight = heightAccumulator - 12;
        this.maxScrollOffset = Math.max(this.combinedEditorHeight - (this.field_22790 - 50), 0);
    }

    private int addToolbarWidgets(List<class_339> widgets) {
        int x = 8;
        for (class_339 widget : widgets) {
            widget.method_46421(x);
            widget.method_46419(this.field_22790 - 28);
            x += widget.method_25368() + 4;
            this.method_37063((class_364)widget);
        }
        return x;
    }

    private void changeFocus(boolean lookForwards) {
        class_364 element = this.method_25399();
        if (element == null) {
            CommandEditor editor = (CommandEditor)this.editors.get(0);
            this.setFocusedEditor(editor);
            return;
        }
        for (int index = 0; index < this.editors.size(); ++index) {
            CommandEditor editor;
            if (!(element instanceof CommandEditor) || !element.equals(this.editors.get(index))) continue;
            do {
                if ((index += lookForwards ? 1 : -1) < 0) {
                    index = this.editors.size() - 1;
                    continue;
                }
                if (index < this.editors.size()) continue;
                index = 0;
            } while (!(editor = (CommandEditor)this.editors.get(index)).isLoaded());
            element.method_25365(false);
            this.setFocusedEditor(editor);
            return;
        }
    }

    public void setFocusedEditor(CommandEditor editor) {
        this.method_25395((class_364)editor);
        editor.method_25365(true);
        this.repositionEditors();
        int top = editor.getY() + this.scrollOffset;
        int bottom = top + editor.getHeight();
        this.setScrollOffset(class_3532.method_15340((int)this.getScrollOffset(), (int)(bottom - this.field_22790 + 36), (int)(top - 8)));
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25420(context, mouseX, mouseY, delta);
        for (CommandEditor editor : this.editors) {
            editor.method_25394(context, mouseX, mouseY, delta);
        }
        for (CommandEditor editor : this.editors) {
            editor.renderSuggestions(context, mouseX, mouseY);
        }
        if (this.maxScrollOffset > 0) {
            int virtualHeight = this.maxScrollOffset + this.field_22790;
            int scrollbarHeight = Math.round((float)this.field_22790 / (float)virtualHeight * (float)this.field_22790);
            int scrollbarPosition = Math.round((float)this.getScrollOffset() / (float)this.field_22790 * (float)scrollbarHeight);
            context.method_25294(this.field_22789 - 3, scrollbarPosition + 1, this.field_22789 - 1, scrollbarPosition + scrollbarHeight - 1, 0x3FFFFFFF);
        }
        super.method_25394(context, mouseX, mouseY, delta);
        if (this.statusText != null) {
            int x = this.statusTextX + 5;
            int y = this.field_22790 - 22;
            int statusTextWidth = this.field_22793.method_27525((class_5348)this.statusText);
            context.method_25294(x - 2, y - 2, x + statusTextWidth + 2, y + 9 + 2, 0x7F000000);
            context.method_27535(this.field_22793, this.statusText, this.statusTextX + 5, this.field_22790 - 22, -1);
        }
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
    }

    @Override
    public boolean isDirty() {
        return this.editors.stream().anyMatch(Dirtyable::isDirty);
    }

    public boolean isLoaded() {
        return this.saveButton.field_22763;
    }

    protected void setLoaded(boolean loaded) {
        this.saveButton.field_22763 = loaded;
    }
}

