/*
 * Decompiled with CFR 0.152.
 */
package arm32x.minecraft.commandblockide.util;

import io.netty.buffer.ByteBuf;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.minecraft.class_2540;
import org.jetbrains.annotations.NotNull;

public final class PacketSplitter
implements Iterable<ByteBuf> {
    public static final int CHUNK_SIZE = 32500;
    public static final int HEADER_MAGIC = 1397771337;
    private final class_2540 source;

    public PacketSplitter(class_2540 source) {
        this.source = source;
    }

    public static void writeHeader(class_2540 buf) {
        buf.method_53002(1397771337);
        buf.method_53002(0);
    }

    public static void updateChunkCount(class_2540 buf) {
        int start = buf.readerIndex();
        if (buf.readInt() != 1397771337) {
            throw new MissingHeaderException();
        }
        int chunkCount = (int)Math.ceil((double)buf.readableBytes() / 32500.0);
        buf.method_52989(start + 4, chunkCount);
        buf.method_52988(start);
    }

    @Override
    @NotNull
    public Iterator<ByteBuf> iterator() {
        if (this.source.getInt(this.source.readerIndex()) != 1397771337) {
            throw new MissingHeaderException();
        }
        return new BufferIterator();
    }

    public static class MissingHeaderException
    extends RuntimeException {
        @Override
        public String getMessage() {
            return "Missing PacketSplitter header.";
        }
    }

    private class BufferIterator
    implements Iterator<ByteBuf> {
        private BufferIterator() {
        }

        @Override
        public boolean hasNext() {
            return PacketSplitter.this.source.readableBytes() > 0;
        }

        @Override
        public ByteBuf next() {
            int length = Math.min(32500, PacketSplitter.this.source.readableBytes());
            if (length <= 0) {
                throw new NoSuchElementException();
            }
            return PacketSplitter.this.source.readSlice(length);
        }
    }
}

